<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\Registro;
use App\Sucursales;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Promotoria;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\PromotoriaRequest;
use Illuminate\Support\Facades\Input;
use App\Tramites;
use Response;
use Excel;

class RegistroController extends Controller
{
    public function __construct() {

        $this->middleware('auth');
    }

    public  function index(Request $request){
        $request->flash();
        if(Auth::user() -> can('read-records')){
            $arrSucursales = Sucursales::select('id','nombre')
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->lists('nombre', 'id')->toArray();
            $arrSucursales = ['0' => 'Todas', ] + $arrSucursales;
            $query = Sucursales::where('promotoria_id',Auth::user()->promotoria_id);
            if ($request->sucursal) {
                $query->where('id', $request->sucursal);
            }

            $sucursales = $query->orderBy('id','ASC')->get();
            return view('registro.index',compact('sucursales', 'arrSucursales'));
        }
    }


    public function show($id){
       $registro= Registro::find($id);
        return view('registro.show',compact('registro'));
    }

    /*
    REQUERIMIENTO: SSM-37
    DESARROLLADOR: David Pascual Martinez
    DESCRIPCION: Exporta un archivo excel con los datos de una o varias sucursales.
    PARAMETROS:
        $form               : Contiene las variables del formulario
        $form->tipo         : Tipo de exportacion de datos, puede ser por fecha o por tramite.
        $inicio             : Fecha de inicio de los registros, solo cuando el tipo es igual a fecha.
        $fin                : Fecha de termino de los registros, solo cuando el tipo es igual a fecha.
        $form->tramite      : Tipo de tramite que se desea exportar.
        $form->idSucursal   : ID de la sucursal, solo cuando la exportacion es individual y debe ser mayor a cero.
    RETORNO:
        Un archivo excel.
     */
    public function export()
    {
        $form = (object) Input::all();
        if ($form->tipo == 'fecha') {
            $inicio = explode('/',$form->inicio);
            $fin = explode('/',$form->fin);
            if ($form->idSucursal > 0) {
                $sucursal = Sucursales::with(['registros' => function ($query) use ($inicio,$fin) {
                    $query->whereBetween('date',[$inicio[2].'-'.$inicio[1].'-'.$inicio[0],$fin[2].'-'.$fin[1].'-'.$fin[0]])
                    ->whereNull('deleted_at')->orderBy('date','DESC');
                }])
                ->where('id',$form->idSucursal)
                ->first();
                $sucursales = [];
                if (count($sucursal->registros) > 0) {
                    $sucursales [] = $sucursal;
                }
            } else {
                $sucursales = Sucursales::with(['registros' => function ($query) use ($inicio,$fin) {
                    $query->whereBetween('date',[$inicio[2].'-'.$inicio[1].'-'.$inicio[0],$fin[2].'-'.$fin[1].'-'.$fin[0]])
                    ->whereNull('deleted_at')->orderBy('date','DESC');
                }])
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->get();
            }
        } elseif ($form->tipo == 'tramite') {
            if ($form->idSucursal > 0) {
                $sucursal = Sucursales::with(['registros' => function ($query) use ($form) {
                    $query->where('tramite_id',$form->tramite)->whereNull('deleted_at');
                }])
                ->where('id',$form->idSucursal)
                ->first();
                $sucursales = [];
                if (count($sucursal->registros) > 0) {
                    $sucursales [] = $sucursal;
                }
            } else {
                $sucursales = Sucursales::with(['registros' => function ($query) use ($form) {
                    $query->where('tramite_id',$form->tramite)->whereNull('deleted_at');
                }])
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->get();
            }
        }
        if (count($sucursales) > 0) {
            if (count($sucursales) == 1) {
                $name = 'Exportacion de '.$sucursales[0]->nombre.' del '.date('d-m-Y');
            } else {
                $name = 'Exportacion de datos del '.date('d-m-Y');
            }
            Excel::create($name, function($excel) use ($sucursales) {
                $excel->sheet('Exportacion', function($sheet) use ($sucursales) {
                    $sheet->loadView('registro.toExcel')
                    ->with('sucursales', $sucursales);
                });
            })->download('xlsx');
        } else {
            Session::flash('message', 'No se encontró información para exportar con los datos proporcionados');
            return redirect('/registro');
        }
    }

    /*
    REQUERIMIENTO: SSM-37
    DESARROLLADOR: David Pascual Martinez
    DESCRIPCION: Consulta los tramites de los que puede exportar.
    PARAMETROS:
        $id:    Id de la sucursal para saber cuales tramites tiene disponible para poder exportar,
                    debe de ser mayor a cero, de otro modo se interpreta que la exportacion sera masiva.
    RETORNO:
        Json con la informacion solicitada.
     */
    public function tramites($id)
    {
        if ($id > 0) {
            $sucursal = Sucursales::find($id);
            if ($sucursal) {
                $registros = $sucursal->registros()->lists('tramite_id');
                $tramites = Tramites::select('id','nombre')->whereIn('id',$registros)->get();
                return Response::json(['status' => 'OK','tramites' => $tramites, ]);
            }
        }elseif ($id == 'exportAll') {
            $sucursales = Sucursales::where('promotoria_id',Auth::user()->promotoria_id)
            ->lists('id');
            $registros = Registro::whereIn('sucursal_id',$sucursales)->lists('id');
            $tramites = Tramites::select('id','nombre')->whereIn('id',$registros)->get();
            return Response::json(['status' => 'OK','tramites' => $tramites, ]);
        }
    }


}
