<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use App\Http\Requests\PromotoriaRequest;
use App\Sucursales;
use App\Registro;
use Response;
use DB;
use Excel;

class ReporteController extends Controller
{
    public function __construct() {

        $this->middleware('auth');
    }

    /*
    REQUERIMIENTO: SSM-43
    DESARROLLADOR: David Pascual Martinez
    DESCRIPCION: Muestra el formulario para poder hacer un reporte.
    PARAMETROS:
        $id:    Id de la sucursal para saber cuales tramites tiene disponible para poder exportar,
                    debe de ser mayor a cero, de otro modo se interpreta que la exportacion sera masiva.
    RETORNO:
        Una vista con un formulario.
    */

    public function index()
    {
        if(Auth::user() -> can('read-records')){
            $sucursales = Sucursales::select('id','nombre')
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->whereNull('deleted_at')->get();
            $meses = $this->meses();
            $tramites = DB::table('tramites')->select('id','nombre')
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->whereNull('deleted_at')->get();
            return view('reporte.index',['meses' => $meses, 'sucursales' => $sucursales, 'tramites' => $tramites, ]);
        }
    }

    public function meses()
    {
        $meses = array('Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
        return $meses;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

    }

    /*
    REQUERIMIENTO: SSM-43
    DESARROLLADOR: David Pascual Martinez
    DESCRIPCION: Crea una vista o archivo Excel con los parametros que se le envien del Formulario.
    PARAMETROS:
        $request:    Formulario con los campos.
    RETORNO:
        Dependiendo de los parametros enviados, devuelve una vista o un archivo Excel.
     */
    public function store(Request $request)
    {
        if ($request->sucursal == -1) {
            $sucursales = Sucursales::where('promotoria_id',Auth::user()->promotoria_id)
                ->lists('id');
            $query = Registro::select('registros.*','sucursales.nombre AS sucursal')
                ->whereIn('sucursal_id',$sucursales)
                ->join('sucursales', 'registros.sucursal_id', '=', 'sucursales.id');
            if ($request->userId) {
                $query->whereHas('usuarios', function ($sQuery) use ($request) {
                    $sQuery ->where('id', $request->userId);
                });
            }
            if ($request->tipo == 'mes') {
                $query->whereMonth('date', '=', $request->mes+1);
            } elseif ($request->tipo == 'rango') {
                $inicio = explode('/',$request->inicio);
                $fin = explode('/',$request->fin);
                $query->where(function ($where) use ($inicio,$fin){
                    $where->whereBetween('date',[$inicio[2].'-'.$inicio[1].'-'.$inicio[0],$fin[2].'-'.$fin[1].'-'.$fin[0]]);
                });
            }
            $registros = $query->orderBy('date')->get();
            $registros = $registros->groupBy('date');
            foreach ($registros as $fecha => $registro) {
                $nCollection = collect($registro);
                $nCollection = $nCollection->sortBy('sucursal');
                $registro->info = $nCollection->groupBy('sucursal');
            }

            if ($request->xportExcel == 'true') {
                Excel::create('Reporte creado el '. date('d-m-Y'), function($excel) use ($registros) {
                    $excel->sheet('Exportacion', function($sheet) use ($registros) {
                        $sheet->loadView('reporte.reporte')
                        ->with('registros', $registros);
                    });
                })->download('xlsx');
            } else {
                return view('reporte.reporte',['registros' => $registros, ]);
            }
        } elseif ($request->sucursal > 0) {
            $sucursal = Sucursales::find($request->sucursal);
            if ($sucursal) {
                $query = Registro::where('registros.sucursal_id', $sucursal->id)
                ->with(['servicios' => function ($sQuery) {
                    $sQuery->groupBy('servicio');
                },]);
                if ($request->userId) {
                    $query->whereHas('usuarios', function ($sQuery) use ($request) {
                        $sQuery ->where('id', $request->userId);
                    });
                }
                if ($request->tipo == 'mes') {
                    $query->whereMonth('date', '=', $request->mes+1);
                } elseif ($request->tipo == 'rango') {
                    $inicio = explode('/',$request->inicio);
                    $fin = explode('/',$request->fin);
                    $query->where(function ($where) use ($inicio,$fin){
                        $where->whereBetween('date',[$inicio[2].'-'.$inicio[1].'-'.$inicio[0],$fin[2].'-'.$fin[1].'-'.$fin[0]]);
                    });
                }
                if ($request->tramite > 0) {
                    $query->where('tramite_id', $request->tramite);
                }
                $registros = $query->orderBy('date')->get();
                if ($request->xportExcel == 'true') {
                    Excel::create('Reporte de '.$sucursal->nombre .' creado el '. date('d-m-Y'), function($excel) use ($registros,$sucursal) {
                        $excel->sheet('Exportacion', function($sheet) use ($registros,$sucursal) {
                            $sheet->loadView('reporte.sucursal')
                                ->with('registros' , $registros)
                                ->with('sucursal' , $sucursal);
                        });
                    })->download('xlsx');
                } else {
                    return view('reporte.sucursal',['registros' => $registros, 'sucursal' => $sucursal, ]);
                }
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($ids,Request $request)
    {
        $ids = $request->ids;
        $registros = [];
        foreach ($ids as $id) {
            $registros[] = Registro::find($id);
        }
        return view('reporte.registro',['registros' => $registros,]);
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
