<?php




Route::group(['prefix' => '/', 'namespace' => '\Auth'], function()
{
    Route::get('/', 'AuthController@index');
    Route::post('/auth/login', ['as' => 'auth.login', 'uses' => 'AuthController@postLogin']);
    Route::get('/auth/logout', ['as' => 'auth.logout', 'uses' => 'AuthController@getLogout']);
    Route::resource('auth/permission', 'PermissionController');
    Route::resource('auth/role', 'RoleController');
    Route::resource('auth/user', 'UserController');
    Route::get('/auth/user/{id}/assign',['as' => '.user.assign', 'uses' => 'UserController@assign']);
    Route::get('/auth/user/getSucursales/{id}',['as' => '.user.suc', 'uses' => 'UserController@getSucursales']);
    Route::get('/auth/user/changePromotoria/{id}',['as' => '.user.prom', 'uses' => 'UserController@changePromotoria']);
    Route::get('/auth/user/sucursalSeleted/{id}',['as' => '.user.prom', 'uses' => 'UserController@sucursalSeleted']);
    Route::post('/auth/user/assign',['as' => 'user.assignPost', 'uses' => 'UserController@assignPost']);
    Route::post('/auth/user/change-password', ['as' => 'user.change-password', 'uses' => 'UserController@changePassword']);
    // Reseteo de contraseñas
    Route::get('password/email', 'PasswordController@getEmail');
    Route::post('password/email', 'PasswordController@postEmail');
    Route::get('password/reset/{token}', 'PasswordController@getReset');
    Route::post('password/reset', 'PasswordController@postReset');
});

Route::group(['middleware' => 'auth'], function () {
        Route::resource('promotoria', 'PromotoriaController');
        Route::resource('documento', 'DocumentosController');
        Route::resource('tramite', 'TramitesController');
        Route::resource('sucursal', 'SucursalesController');
        Route::resource('ventanilla', 'VentanillasController');
        Route::get('export/tramites/{id}','RegistroController@tramites');
        Route::get('export','RegistroController@export');
        Route::resource('registro', 'RegistroController');
        Route::resource('reporte', 'ReporteController');
        Route::resource('reasons', 'ReasonController');
});


Route::group(['prefix' => 'api/v1','namespace' => '\Api'], function(){
    Route::post('login', 'AuthController@login');

    //Route::group(['middleware' => ['jwt.auth', 'jwt.refresh']], function() {
    Route::group(['middleware' => ['jwt.auth']], function() {
        Route::post('logout', 'AuthController@logout');
        Route::get('config', 'SstController@config');
        Route::get('getProcedures', 'SstController@getProcedures');
        Route::get('{policie}/getPayOrderData', 'SstController@getPayOrderData');
        Route::post('startProcedureAttention', 'SstController@startProcedureAttention');
        Route::post('stopProcedureAttention', 'SstController@stopProcedureAttention');
        Route::get('/{name}/getCustomersByName', 'SstController@getCustomersByName');
        Route::get('url', 'SstController@url');
        Route::get('results','SstController@results');
        Route::post('storeService','SstController@storeService');
        Route::get('cartera', 'SstController@cartera');
        Route::get('detalle', 'SstController@detalle');
        Route::get('servicio/detalle', 'SstController@detalleServicio');
        Route::get('test2', 'SstController@test');
        Route::get('{policie}/getPayOrderDataDemo', 'SstController@getPayOrderDataDemo');
        Route::get('reasonsList','SstController@reasonDeclined');
        Route::get('startResumenReasons', 'SstController@startResumenReasons');
    });
});
