<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUsersPivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_tramites', function (Blueprint $table) {
            $table->integer('user_id')->unsigned();
            $table->integer('tramite_id')->unsigned();

            $table->foreign('user_id')->references('id')->on('user')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('tramite_id')->references('id')->on('tramites')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->primary(['user_id', 'tramite_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
