@extends('layouts.master')

@section('style')
    <link href="{{ asset('js/jquery-multi-select/css/multi-select.css') }}" rel="stylesheet" />
@stop

@section('content')
    <section class="wrapper">
        @include('partials.message')
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8 col-md-offset-2">
                    <div class="panel panel-default">
                        <div class="panel-heading">{{ trans('ui.user.assign_procedures') }}</div>
                        <div class="panel-body">
                            @include('errors.form_error')
                            {!! Form::model($user, ['method' => 'POST', 'route' => ['user.assignPost'], 'class' => 'cmxform form-horizontal', 'id' => 'nameForm']) !!}
                            {!! Form::hidden('id',$user -> id) !!}
                            <div class="form-group">
                                <label  class="col-lg-2 col-sm-2 control-label">{{ trans('ui.procedures.names') }}</label>
                                <div class="col-lg-10">
                                    {!! Form::select('procedures_id[]', $tramites, isset($user_tramite) ? $user_tramite : null, array(
                                    'multiple' => true, 'class' => 'multi-select', 'id' => 'permissionSelect')) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-offset-2 col-lg-8">
                                    {!! Form::submit(trans('ui.user.button_update'), ['class' => 'btn btn-primary']) !!}
                                    <a href = "{{URL::to('auth/user')}}" class = 'btn btn-danger'>Regresar</a>

                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script')
    <script src="{{ asset('js/validation/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('js/validation/validation-init.js') }}"></script>
    <script src="{{ asset('js/jquery-multi-select/js/jquery.multi-select.js') }}"></script>
    <script src="{{ asset('js/multi-select-init.js') }}"></script>
@stop