@extends('layouts.master')

@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop

    @section('content')

            <!--body wrapper start-->
    <div class="wrapper">
        @include('partials.message')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.user.names') }} {{ $sucursalId[0]['nombre'] }}
                        <span class="tools pull-right">
                <a href="javascript:;" class="fa fa-chevron-down"></a>
             </span>
                    </header>
                    <div class="panel-body">
                        <div class="adv-table">
                           @if(Auth::user()->can('create-users'))
                                <a href="{{ url('auth/user/create') }}">
                                    <button class="btn btn-primary pull-right" type="button">
                                        <i class="fa fa-plus-circle"></i> {{ trans("ui.user.button_add") }}</button></a>
                            @endif

                               <div  class="menu-right-sucursal">
                                   <ul class="notification-menu">
                                           <li>
                                           <a href="#" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                               Selecione una sucursal
                                               <span class="caret"></span>
                                           </a>
                                           <ul class="dropdown-menu dropdown-menu-usermenu pull-right">
                                               @foreach($sucursales as $sucursal)
                                                   <li><a href="{{ url('auth/user/sucursalSeleted/'.$sucursal -> id) }}"><i class="fa fa-key"></i> <span> {{ $sucursal -> nombre }}</span></a></li>
                                               @endforeach
                                           </ul>
                                       </li>
                                   </ul>
                               </div>

                            <table  class="display table table-bordered table-striped" id="dynamic-table">
                                <thead>
                                <tr>
                                    <th>{{ trans('ui.user.firstname') }}</th>
                                    <th>{{ trans('ui.user.lastname') }}</th>
                                    <th>{{ trans('ui.user.username') }}</th>
                                    <th>{{ trans('ui.user.email') }}</th>
                                    <th>{{ trans('ui.role.names') }}</th>
                                    <th>{{ trans('ui.procedures.names') }}</th>

                                @if(Auth::user()->can(['update-users', 'delete-users']))
                                        <th>{{ trans('ui.user.operation_label') }}</th>
                                    @endif
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($users as $user)

                                    <tr class="gradeX">
                                        <td>{{ $user->firstname }}</td>
                                        <td>{{ $user->lastname }}</td>
                                        <td>{{ $user->username }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td><ul>
                                                @foreach($user->roles as $role)
                                                    <li>
                                                        {{ $role->display_name }}
                                                    </li>
                                                @endforeach
                                        </ul></td>
                                        <td><ul>
                                                @foreach($user->tramites as $tramite)
                                                    <li>
                                                        {{ $tramite-> nombre }}
                                                    </li>
                                                @endforeach
                                            </ul></td>
                                        @if(Auth::user()->can(['update-users', 'delete-users']))
                                            <td>

                                                    @if(Auth::user()->can('update-users'))
                                                        <a href="{{ url('auth/user/' . $user->id . '/edit') }}">
                                                            <i class="fa fa-refresh"></i>
                                                        </a>
                                                    @endif
 						    @if(Auth::user()->can('assign-procedures'))
						       @if($user->can('use-api-as-agent'))
                                                        
                                                            <a href="{{ url('auth/user/' . $user->id . '/assign') }}">
                                                                <i class="fa fa-check"></i>
                                                            </a>
                                                      
						       @endif
                                                    @endif												
                                                    @if(Auth::user()->can('delete-users'))
                                                        {!! Form::open(['url' => 'auth/user/'. $user->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                            <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                        {!! Form::close() !!}
                                                    @endif
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    @stop

    @section('script')
            <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop