@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/bower_components/select2/dist/css/select2.min.css')}}" />
    <link rel="stylesheet" href="{{asset('css/export.css')}}" />
    @stop


    @section('content')
            <!--body wrapper start-->
    <div class="wrapper">
        @include('partials.message')
        @include('partials.exportData')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        <div class="row">
                            {!! Form::open(['method' => 'get', 'url' => '/registro', 'class' => 'form-horizontal']) !!}
                            <div class="form-group{{ $errors->has('sucursal') ? ' has-error' : '' }} col-sm-8">
                                {!! Form::label('sucursal', 'Sucursal', ['class' => 'col-sm-3 control-label']) !!}
                                <div class="col-sm-9">
                                    {!! Form::select('sucursal',$arrSucursales, null, ['class' => 'form-control', 'required' => 'required', 'id' => 'sucursal', ]) !!}
                                    <small class="text-danger">{{ $errors->first('sucursal') }}</small>
                                </div>
                            </div>
                            {!! Form::submit("Buscar", ['class' => 'btn btn-success']) !!}
                            {!! Form::close() !!}
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                {{ trans('ui.record.names') }}
                            </div>
                            <div class="col-sm-6">
                                <span class="tools pull-right">
                                    <a href="javascript:;" class="fa fa-chevron-down"></a>
                                </span>
                                <a href="#modalExportData" id="exportAll" class="pull-right" style="color:#535351;" data-toggle="modal">
                                    Exportar Todo
                                    <i class="fa fa-download" aria-hidden="true"></i>
                                </a>
                            </div>
                        </div>
                    </header>
                    <div class="panel-body">
                        @foreach($sucursales as $key => $sucursal)
                            <div class="row">
                                <div class="col-sm-12">
                                    <section class="panel">
                                        <header class="panel-heading">
                                            Sucursal <a href="{{url('sucursal')}}/{{$sucursal->id}}" style="color:#535351;"> {{ $sucursal->nombre }}</a>
                                            <a href="{{url('sucursal')}}/{{$sucursal->id}}" style="color:#535351;"><i class="fa fa-eye" aria-hidden="true"></i> Ver</a>
                                            @if(count($sucursal->registros) > 0)
                                                <a href="#modalExportData" class="pull-right btn-mod-export" style="color:#535351;" data-toggle="modal" id="{{$sucursal->id}}">
                                                    Exportar {{$sucursal->registros->count()}} Registros <i class="fa fa-download" aria-hidden="true"></i>
                                                </a>
                                            @endif
                                        </header>
                                    </section>
                                </div>
                            </div>

                        @endforeach

                    </div>
                </section>
            </div>
        </div>
    </div>
    @stop

    @section('script')
            <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    {{-- <script src="{{ asset('js/dynamic_table_init.js') }}"></script> --}}

    {{-- The plugin datetimepicker --}}
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/min/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/locale/es.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/select2/dist/js/select2.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/export.js')}}"></script>
    <script type="text/javascript">
        $(function () {
            $('#sucursal').select2();
        });
    </script>
@stop
