@extends('layouts.master')
@section('style')
    {!! Html::style('assets/bower_components/select2/dist/css/select2.css') !!}
    {!! Html::style('assets/bower_components/select2-bootstrap-theme/dist/select2-bootstrap.css') !!}
    <link rel="stylesheet" href="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css')}}" />
    <style>
        @media print {
            #contentReports {
                background-color: white;
                height: 100%;
                width: 100%;
                position: fixed;
                top: 0;
                left: 0;
                margin: 0;
                padding: 15px;
                font-size: 14px;
                line-height: 18px;
            }
        }
    </style>
@endsection

@section('content')
    <div class="wrapper">
        @include('reporte.detalleGeneral')
        @include('partials.message')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.reports.names') }}
                    </header>
                    <div class="panel-body">
                        <div class="box">
                            {!! Form::open(['method' => 'POST', 'action' => 'ReporteController@store', 'id' => 'formDataReports' ]) !!}
                            <div class="form-group col-sm-12 ui-widget">
                                <label for="userName">Nombre de usuario</label>
                                <select class="form-control" name="userId" id="userName"></select>
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="tipo">Fecha por:</label>
                                <select class="form-control" name="tipo" id="tipo">
                                    <option value="mes">Mes</option>
                                    <option value="rango">Rango de Fechas</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <div class="col-xs-8 group-mont">
                                    <div class="form-group">
                                        <label for="mes">Mes seleccionado:</label>
                                        <select class="form-control" name="mes" id="mes">
                                            @foreach($meses as $id => $mes)
                                                <option value="{{$id}}">{{$mes}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-xs-4 group-date hidden">
                                    <div class="form-group">
                                        <label for="inicio">Inicio</label>
                                        <div class='input-group date' id='dtpInicio'>
                                            <input type='text' class="form-control" name="inicio"/>
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar" aria-hidden="true"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-4 group-date hidden">
                                    <div class="form-group">
                                        <label for="fin">Fin</label>
                                        <div class='input-group date' id='dtpFin'>
                                            <input type='text' class="form-control" name="fin"/>
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar" aria-hidden="true"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-xs-4">
                                    <label for="sucursal">Sucursal</label>
                                    <select class="form-control" name="sucursal" id="sucursal">
                                        <option value="-1">Todas</option>
                                        @foreach($sucursales as $sucursal)
                                            @if(count($sucursal->ventanillas) > 0)
                                                <option value="{{$sucursal->id}}">{{$sucursal->nombre}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xs-4 group-filters hidden">
                                    <label for="tramite">Trámites</label>
                                    <select class="form-control" name="tramite" id="tramite">
                                        <option value="-1">Todas</option>
                                        @foreach($tramites as $tramite)
                                            <option value="{{$tramite->id}}">{{$tramite->nombre}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-xs-12">
                                <hr>
                            </div>
                            <div class="col-xs-12">
                                <div class="col-xs-3">
                                    <div class="btn-group pull-left">
                                        <input type="hidden" name="xportExcel" value="false" id="xportExcel">
                                        <button type="submit" class="btn btn-success" id="btnExportXL">Exportar Excel <i class='fa fa-file-excel-o' aria-hidden='true'></i></button>
                                    </div>
                                </div>
                                <div class="col-xs-3">
                                    <div class="btn-group pull-left">
                                        <button type="submit" class="btn btn-danger" id="btnImprimir">Imprimir</button>
                                    </div>
                                </div>
                                <div class="btn-group pull-right">
                                    <button type="button" name="button" class="btn btn-primary hidden" id="btnWaitReport"><i class="fa fa-circle-o-notch fa-spin fa-fw"></i></button>
                                    {!! Form::submit("Ver Reporte", ['class' => 'btn btn-primary','id' => 'btnVerReporte', ]) !!}
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                        <div class="box" id="contentReports">
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript" src="{{asset('assets/bower_components/select2/dist/js/select2.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/min/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/locale/es.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/reports.js')}}"></script>

    <script>
        function myFunction() {
            window.print();
        }
    </script>
@endsection
