@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop


@section('content')
        <!--body wrapper start-->
    <div class="wrapper">
           @include('partials.message')
           <div class="row">
               <div class="col-sm-12">
                   <section class="panel">
                       <header class="panel-heading">
                             {{ trans('ui.branches.names') }}
                             <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                       </header>
                       <div class="panel-body">
                           @if(Auth::user() -> can(['create-branches']))
                               <a href="{{ url('sucursal/create') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.branches.button_add") }}</button></a>
                           @endif
                           <table class="display table table-bordered table-striped" id="dynamic-table">
                               <thead>
                                    <tr>
                                        <th>{{ trans('ui.branches.name') }}</th>
                                        @if(Auth::user()->can(['update-branches', 'delete-branches']))
                                            <th>{{ trans('ui.branches.operation_label') }}</th>
                                        @endif
                                    </tr>
                               </thead>
                               <tbody>
                               @foreach($sucursales as $sucursal)
                                   <tr>
                                       <td>{{ $sucursal->nombre }}</td>
                                       @if(Auth::user()->can(['update-branches', 'delete-branches']))
                                           <td>
                                                   @if(Auth::user()->can('update-branches'))
                                                       <a href="{{ url('sucursal/' . $sucursal->id . '/edit') }}">
                                                           <i class="fa fa-refresh"></i>
                                                       </a>
                                                   @endif

                                                   @if(Auth::user()->can('delete-branches'))
                                                       {!! Form::open(['url' => 'sucursal/'. $sucursal->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                       <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                       {!! Form::close() !!}
                                                   @endif
                                           </td>
                                       @endif
                                   </tr>
                               @endforeach
                               </tbody>
                           </table>
                       </div>
                   </section>
               </div>
           </div>
    </div>
@stop

@section('script')
        <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop
