@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop


@section('content')
        <!--body wrapper start-->
    <div class="wrapper">
           @include('partials.message')

        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.windows.names') }}
                        <span class="tools pull-right">
                          <a href="javascript:;" class="fa fa-chevron-down"></a>
                         </span>
                    </header>
                    <div class="panel-body">
                        @if(Auth::user() -> can(['create-windows']))
                            <a href="{{ url('ventanilla/create') }}" class="pull-right"><button class="btn btn-primary" style="margin-bottom: 1em;" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.windows.button_add") }}</button></a>
                        @endif

                        @foreach($sucursales as $key => $sucursal)
                            <div class="row">
                                <div class="col-sm-12">
                                    <section class="panel">
                                        <header class="panel-heading">
                                            Sucursal {{ $sucursal -> nombre }}
                                        </header>
                                        <div class="panel-body">

                                            <table class="display table table-bordered table-striped" >
                                                <thead>
                                                <tr>
                                                    <th>{{ trans('ui.windows.name') }}</th>
                                                    @if(Auth::user()->can(['update-windows', 'delete-windows']))
                                                        <th>{{ trans('ui.windows.operation_label') }}</th>
                                                    @endif
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach($sucursal -> ventanillas() -> orderBy('nombre','asc') -> get() as $ventanilla)
                                                    <tr>
                                                        @if(strlen($ventanilla->nombre) > 10)
                                                            <td style="width: 50%;" title="{{$ventanilla->nombre}}">{{ str_limit($ventanilla->nombre,10) }}</td>
                                                        @else
                                                            <td style="width: 50%;">{{ $ventanilla->nombre }}</td>
                                                        @endif
                                                        @if(Auth::user()->can(['update-branches', 'delete-branches']))
                                                            <td>
                                                                <div class="pull-right windows-wrapper" >
                                                                    <p style="display: inline-block;">
                                                                        @if(Auth::user()->can('update-branches'))
                                                                            <a href="{{ url('ventanilla/' . $ventanilla->id . '/edit') }}">
                                                                                <i class="fa fa-refresh"></i>
                                                                            </a>
                                                                        @endif

                                                                        @if(Auth::user()->can('delete-branches'))
                                                                                {!! Form::open(['url' => 'ventanilla/'. $ventanilla->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                                                <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                                                {!! Form::close() !!}
                                                                        @endif
                                                                    </p>
                                                                </div>

                                                            </td>
                                                        @endif
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </section>
                                </div>
                            </div>

                        @endforeach









                    </div>
                </section>
            </div>
        </div>
        {{--AQUI EMPIEZA--}}



        {{--AQUI TERMINA--}}
    </div>
@stop

@section('script')
        <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop
